package view;

import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import model.ProxyEvent;
import control.EnterListener;

public class EventPanel extends JPanel {

	private static final long serialVersionUID = 1L;
	private ProxyEvent event;

	private JLabel eventLabel = new JLabel("Evento");
	private JTextField eventText = new JTextField(20);
	private JLabel dateLabel = new JLabel("Data");
	private JTextField dateText = new JTextField(5);
	private JLabel placeLabel = new JLabel("Luogo");

	private String[] PLACES = new String[] { "Austria", "Italia", "Francia",
			"Spagna", "Inghilterra",

			"Russia", "Germania/Prussia", "Altro" };
	private JComboBox<String> box = new JComboBox<String>(PLACES);

	public EventPanel(ProxyEvent event) {
		this.event = event;

		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout());

		JButton button = new JButton("Invio");

		add(eventLabel);
		add(eventText);
		add(dateLabel);
		add(dateText);
		add(placeLabel);
		add(this.box);
		add(button);

		EnterListener listener = new EnterListener(this.event, eventText,
				dateText, box);
		button.addActionListener(listener);

	}
}
